/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block;

import com.renyigesai.immortalers_delight.util.ItemUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpoonBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty SERVINGS = IntegerProperty.m_61631_((String)"servings", (int)0, (int)3);
    public static final VoxelShape BOX = SpoonBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public final Supplier<Item> spoonItem;

    public SpoonBlock(BlockBehaviour.Properties p_49795_, Supplier<Item> spoonItem) {
        super(p_49795_);
        this.spoonItem = spoonItem;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(3))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BOX;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_60508_) {
        return level.f_46443_ && this.takeServing(state, level, pos, player, hand).m_19077_() ? InteractionResult.SUCCESS : this.takeServing(state, level, pos, player, hand);
    }

    public ItemStack getSpoonItem() {
        return new ItemStack((ItemLike)this.spoonItem.get());
    }

    public ItemStack getRemainItem() {
        return new ItemStack((ItemLike)Items.f_42399_);
    }

    public InteractionResult takeServing(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        int servings = (Integer)state.m_61143_((Property)SERVINGS);
        if (servings > 0) {
            ItemStack hand_stack = player.m_21120_(hand);
            if (hand_stack.m_150930_(this.getScoopItem().m_41720_())) {
                if (!player.m_150110_().f_35937_) {
                    hand_stack.m_41774_(1);
                }
            } else {
                player.m_5661_((Component)Component.m_237110_((String)"block.immortalers_delight.spoon_block.tips.1", (Object[])new Object[]{this.getScoopItem().m_41720_().m_41466_().getString()}), true);
                return InteractionResult.FAIL;
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
            ItemUtils.givePlayerItem(player, this.getSpoonItem());
            level.m_5594_(null, pos, this.getScoopSound(), SoundSource.PLAYERS, 0.8f, 0.8f);
            return InteractionResult.SUCCESS;
        }
        if (servings == 0) {
            level.m_46961_(pos, false);
            this.dropRemainItem(level, pos);
            level.m_5594_(null, pos, this.getScoopSound(), SoundSource.PLAYERS, 0.8f, 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public ItemStack getScoopItem() {
        return new ItemStack((ItemLike)Items.f_42399_);
    }

    public SoundEvent getScoopSound() {
        return SoundEvents.f_12639_;
    }

    public void dropRemainItem(Level level, BlockPos pos) {
        vectorwing.farmersdelight.common.utility.ItemUtils.spawnItemEntity((Level)level, (ItemStack)this.getRemainItem(), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (double)0.0, (double)0.0, (double)0.0);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SERVINGS, FACING});
    }
}

